<?php

/**
 * Constant Secret key on remote server to activate and check license keys
 */
define( "LOC_UP_REMOTE_SECRET_KEY", "684fb0329fab74.81988233" );
define( "LOC_UP_REMOTE_URL", "https://mishimou-business.com" );

/**
 * Activate license key from remote server
 * @param string $license_key
 * @return void
 */
function loc_up_activate_license_key( $license_key ) {
    if( ! $license_key || strlen( $license_key ) <= 0 ) {
        loc_up_admin_message( "error", "Please add a license key for Locker Up plugin" );
        return; # There is no license key to check
    }

    $api_params = array(
        "slm_action" => "slm_activate",
        "secret_key" => LOC_UP_REMOTE_SECRET_KEY,
        "license_key" => $license_key,
        "registered_domain" => $_SERVER["SERVER_NAME"],
        "item_reference" => "LockerUp plugin copy for site: " . get_bloginfo( "name" )
    );

    # Send query to license manager server
    $query = esc_url_raw( add_query_arg( $api_params, LOC_UP_REMOTE_URL ) );
    $response = wp_remote_get( $query );

    // Check for error
    if( is_wp_error( $response ) ) {
        loc_up_admin_message( "error", "Locker Up License Activation Error: " . $response->get_error_message() );
    }

    // License data
    $license_data = json_decode(wp_remote_retrieve_body( $response ) );
    loc_up_log( print_r( $license_data, true ) );

    if( $license_data ) {
        if( $license_data->result === "success" ) {
            update_option( "loc_up_license_key", $license_key, false ); # Update the plugin expiry date

            loc_up_admin_message( "success",  "Locker Up License Activation: " . $license_data->message );
        } else {
            # An error was encountered
            loc_up_admin_message( "info", "Locker Up License Activation Error: " . $license_data->message );
        }
    }
}

/**
 * Check license key from remote server
 * Retrieve additional details ie: license_status and expirt date not returned in slm_activate
 * @param string $license_key
 * @return void
 */
function loc_up_check_license_key( $license_key ) {
    if( ! $license_key || strlen( $license_key ) <= 0 ) {
        loc_up_admin_message( "error", "Please add a license key for Locker Up plugin" );
        return; # There is no license key to check
    }

    $api_params = array(
        "slm_action" => "slm_check",
        "secret_key" => LOC_UP_REMOTE_SECRET_KEY,
        "license_key" => $license_key,
    );

    # Send query to license manager server
    $query = esc_url_raw( add_query_arg( $api_params, LOC_UP_REMOTE_URL ) );
    $response = wp_remote_get( $query );

    // Check for error
    if( is_wp_error( $response ) ) {
        loc_up_admin_message( "error", "Locker Up License Check Error: " . $response->get_error_message() );
    }

    // License data
    $license_data = json_decode(wp_remote_retrieve_body( $response ) );

    if( $license_data ) {
        if( $license_data->result === "success" ) {
            update_option( "loc_up_license_expiry", $license_data->date_expiry, false ); # Update the plugin expiry date
            update_option( "loc_up_license_status", $license_data->status, false ); # Update the plugin status

            loc_up_admin_message( "info",  "Locker Up License Check: " . $license_data->message );
        } else {
            # An error was encountered
            loc_up_admin_message( "error", "Locker Up License Check Error: " . $license_data->message );
            loc_up_admin_message( "info", "License Key License Check Status: " . $license_data->status );
        
            update_option( "loc_up_license_expiry", "", false ); # Update the plugin expiry date
            update_option( "loc_up_license_status", "unknown", false ); # Update the plugin status
        }
    }
}

/**
 * Check if the current license key is valid
 * @return bool
 */
function loc_up_check_local_license_key() {
    $license_key = get_option( "loc_up_license_key", "" );
    $license_status = get_option( "loc_up_license_status", "" );
    $license_expiry = get_option( "loc_up_license_expiry", "" );

    if( $license_key === "" || $license_status !== "active" ) {
        loc_up_log( "Plugin status: {$license_status}. Expiry date: {$license_expiry}" );
        return false;
    }
    return true;
}