/**
 * Open wordpress media to select an image -> image URL
 * @param {Event} event 
 * @param {String} inputId 
 */
function openMediaSelector(event, inputId) {
    event.preventDefault();
    const mediaFrame = wp.media({
        title: 'Select Logo',
        button: { text: 'Use this logo' },
        multiple: false
    });
    mediaFrame.on('select', function () {
        const attachment = mediaFrame.state().get('selection').first().toJSON();
        document.getElementById(inputId).value = attachment.url;
    });
    mediaFrame.open();
}

jQuery(document).ready(function($) {
    let packingLabelSize = $("[name='packing_label_size']:checked").val();
    let shippingLabelSize = $("[name='shipping_label_size']:checked").val();

    if(packingLabelSize === "Paper roll") $("#packing-roll-dimensions").addClass("show");
    if(shippingLabelSize === "Paper roll") $("#shipping-roll-dimensions").addClass("show");

    // Show packing paper roll dimensions only if "Paper roll" is selected
    $("[name='packing_label_size']").on("change", function() {        
        if($(this).val() === "Paper roll") {
            $("#packing-roll-dimensions").addClass("show");
        } else {
            $("#packing-roll-dimensions").removeClass("show");
            $("[name='packing_roll_width']").val(210); // A4 = 210mm wide
            $("[name='packing_roll_printable_area']").val(210); // A4 = 210mm wide
        }
    })
    
    // Show shipping paper roll dimensions only if "Paper roll" is selected
    $("[name='shipping_label_size']").on("change", function() {
        if($(this).val() === "Paper roll") {
            $("#shipping-roll-dimensions").addClass("show");
        } else {
            $("#shipping-roll-dimensions").removeClass("show");
            $("[name='shipping_roll_width']").val(210); // A4 = 210mm wide
            $("[name='shipping_roll_printable_area']").val(210); // A4 = 210mm wide
        }
    })
})