<?php

/**
 * Enqueue wordpress media scripts
 * Will ensure wp.media is visible
 * @param mixed $hook
 * @return void
 */
function loc_up_enqueue_admin_media_uploader( $hook ) {
    if( $hook === "toplevel_page_locker-up" ) {
        wp_enqueue_media();
    }
}
# Enqueue admin scripts
add_action( "admin_enqueue_scripts", "loc_up_enqueue_admin_media_uploader" );

# Create an admin page
function loc_up_admin_page() {
    add_menu_page(
        "Locker Up", # Page title
        !loc_up_check_local_license_key() ? sprintf( "Locker Up <span class='awaiting-mod'>%d</span>", 1 ) : "Locker Up", # Menu title
        "manage_options", # Capability
        "locker-up", # Menu slug
        "loc_up_render_admin_page", # Markup callback fn
        "dashicons-location-alt" # Icon
    );
}
add_action( "admin_menu", "loc_up_admin_page" );

/**
 * Render the admin page
 * @return void
 */
function loc_up_render_admin_page() {
	$tab = isset( $_GET["tab"] ) ? $_GET["tab"] : null;
    ?>
    <div class="wrap">
        <!-- Plugin logo ------>
         <img src="<?php echo LOC_UP_PLUGIN_PATH ; ?>/public/assets/Lockerup-Logo.png" alt="LockerUp Logo" width="200">
        <!-- End Plugin logo -->

        <!-- Tabs navigation ------>
         <nav class="nav-tab-wrapper">
			<a href="?page=locker-up&tab=settings" class="nav-tab <?php echo $tab == "settings" ? "nav-tab-active" : ""; ?>">Settings</a>
			<a href="?page=locker-up&tab=license" class="nav-tab <?php echo $tab == "license" ? "nav-tab-active": ""; ?>">License</a>
		 </nav>
        <!-- End Tabs navigation -->

         <!-- Check if required plugins exist ------>
        <?php if( ! loc_up_check_required_plugins() ) : ?>
                <div class='notice notice-error'><p>Locker Up Plugin requires either <strong>ACS Points</strong> or <strong>BOX NOW delivery</strong> or BOTH to be installed and  active</p></div>
        <?php return; 
            endif;
        ?>
        <!-- End Check if required plugins exist -->

        <!-- Tabs ------->
         <div class="tab-content" style="padding:30px 0">
            <?php switch( $tab ) : 
                case "license":
                    $license_key = get_option( "loc_up_license_key", "" );
                    $license_status = get_option( "loc_up_license_status", "" );
                    $license_key_expires = get_option( "loc_up_license_expiry", "" );
                    $license_key_expires_formatted = $license_key_expires !== "" ? date( "d/m/Y", strtotime( $license_key_expires ) ) : "";
                ?>
                    <h1>License key</h1>
                    
                    <?php if( ! loc_up_check_local_license_key() ) : ?>
                        <div class='notice notice-error'><p>Missing/Invalid license key. Please contact <a href="mailto:nas@mishimou-business.com">nas@mishimou-business.com</a> to resolve this.</p></div>
                    <?php else : ?>
                        <div class='notice notice-info'><p>Locker Up license active until <?= $license_key_expires_formatted; ?></p></div>
                    <?php endif; ?>

                    <form method="POST" action="">
                        <input type="hidden" name="loc_up_save_license_nonce" value="1">
                        <label for="loc_up_license_key"><strong>License key</strong></label>
						<input type="text" name="loc_up_license_key" class="regular-text" id="loc_up_license_key" value="<?php echo $license_key; ?>" placeholder="Enter your license key" />
                        <?php submit_button( "Save license key" ) ; ?>
                    </form>
                    <small>License status: <?php echo $license_status; ?></small>
                    <br>
                    <small>License expires on <?php echo $license_key_expires_formatted; ?></small>
                <?php
                    break;
                    default:
                ?>
                <h1>Print Settings</h1>
                <form method="POST" action="options.php">
                    <?php settings_fields( "loc_up_settings_group" ); ?>

                    <!----- Options Container ----------->
                    <div class="loc-up-admin-container">
                        <div class="loc-up-column"><!--- Column ---->
                            <div class="loc-up-column-inner loc-up-column-inner-title">
                                <h3>Packing Slip/Receipt</h3>
                            </div>

                            <div class="loc-up-column-inner">
                                <h3>SELECT LABEL SIZE</h3>
                                <label>
                                    <input type="radio" name="packing_label_size" value="A4" <?php checked( get_option( "packing_label_size" ), "A4" ); ?> />
                                    A4
                                </label><br>
                                <label>
                                    <input type="radio" name="packing_label_size" value="Paper roll" <?php checked( get_option( "packing_label_size" ), "Paper roll" ); ?> />
                                    Paper roll
                                </label>
                            </div>

                            <div class="loc-up-column-inner" id="packing-roll-dimensions">
                                <h3>PAPER ROLL DIMENSIONS</h3>
                                <label>
                                    ENTER ROLL WIDTH (mm)
                                    <input type="number" name="packing_roll_width" value="<?php echo esc_attr( get_option( "packing_roll_width" ) ); ?>"/>
                                </label><br>
                            </div>
                            
                            <div class="loc-up-column-inner">
                                <h3>SELECT LOGO</h3>
                                <input type="text" name="packing_logo" id="packing_logo" value="<?php echo esc_attr( get_option( "packing_logo" ) ); ?>" />
                                <button class="button" onclick="openMediaSelector(event, 'packing_logo')">Select Logo</button>
                            </div>
                            
                            <div class="loc-up-column-inner">
                                <h3>ENTER VAT NUMBER</h3>
                                <input type="text" name="vat_number" value="<?php echo esc_attr( get_option( "vat_number" ) ); ?>" />
                            </div>

                            <div class="loc-up-column-inner">
                                <h3>ENTER GREETING</h3>
                                <textarea name="greeting"><?php echo esc_textarea( get_option( "greeting" ) ); ?></textarea>
                            </div>
                        </div><!--- End column ---->
                        
                        <div class="loc-up-column"><!--- Column ---->
                            <div class="loc-up-column-inner loc-up-column-inner-title">
                                <h3>Shipping Label</h3>
                            </div>
                            <div class="loc-up-column-inner">
                                <h3>SELECT LABEL SIZE</h3>
                                <label>
                                    <input type="radio" name="shipping_label_size" value="A4" <?php checked( get_option( "shipping_label_size" ), "A4" ); ?> /> 
                                    A4
                                </label><br>
                                <label>
                                    <input type="radio" name="shipping_label_size" value="Paper roll" <?php checked( get_option( "shipping_label_size" ), "Paper roll" ); ?> />
                                    Paper roll
                                </label>
                            </div>
                            <div class="loc-up-column-inner" id="shipping-roll-dimensions">
                                <h3>PAPER ROLL DIMENSIONS</h3>
                                <label>
                                    ENTER ROLL WIDTH (mm)
                                    <input type="number" name="shipping_roll_width" value="<?php echo esc_attr( get_option( "shipping_roll_width" ) ); ?>"/>
                                </label><br>
                            </div>
                            <div class="loc-up-column-inner" id="shipping-return-address">
                                <h3>RETURN ADDRESS</h3>
                                <textarea name="shipping_return_address" id="shipping_return_address" rows="5" cols="50" class="large-text"><?php echo esc_textarea( get_option( "shipping_return_address" ) ); ?></textarea>
                            </div>
                        </div><!--- End column ---->
                    </div><!----- End Options Container ------->

                    <?php submit_button( "Save settings" ); ?>
                </form> 
            <?php endswitch; ?>
         </div>
        <!-- End Tabs --->       
    </div>

    <?php
}

# Check if license key is being saved
function loc_up_save_license() {
    if( isset( $_POST["loc_up_save_license_nonce"] ) ) {
        $license_key = sanitize_text_field( $_POST["loc_up_license_key"] );
        loc_up_activate_license_key( $license_key );
        loc_up_check_license_key( $license_key );
    }
}

add_action( "admin_init", "loc_up_save_license" );