<?php

# Register a REST endpoint for downloading the pdfs
add_action( "rest_api_init", function() {
    register_rest_route( "lockerup-pdfs/v1", "/download", array(
        "methods" => "GET",
        "callback" => "loc_up_downloads",
        "permission_callback" => "loc_up_downloads_auth"
    ) );
} );

/**
 * Middleware
 * Callback function on the lockerup-pdfs/v1/download rest route
 * Verifies the nonce to restrict/allow access
 * @return WP_Error|bool
 */

function loc_up_downloads_auth( ) {
    if( ! isset( $_GET["key"] ) || ! isset( $_GET["order_id"] ) ) { # check that nonce and order_id are set
        return new WP_Error( "rest_forbidden", esc_html( "Missing values" ) );
    }
    $order_id = $_GET["order_id"];

    if( $_GET["key"] !== "f0c91a4dcc" ) { # Verify the key
        return new WP_Error( "rest_forbidden", esc_html( "Restricted access" ) );
    }

    return true;
}

/**
 * Function called when a user visits lockerup-pdfs/v1/download
 * @param WP_REST_Request $request
 * @return WP_REST_Response|WP_Error
 */
function loc_up_downloads( WP_REST_Request $request ) {
    $file = basename( $request->get_param( "file" ) );

    if( empty( $file ) || ! preg_match( "/\.pdf$/i", $file ) ) { # File requested is not a pdf
        return new WP_Error( "Invalid file type", 400 );
    }

    $file_path = LOC_UP_PRIVATE_DIR . "/" . $file;

    if( ! file_exists( $file_path ) ) { # File not found
        return new WP_Error( "File not found", 404 );
    }

    # Force download
    header( "Content-Type: application/pdf" );
    header( "Content-Disposition: attachment; filename=$file" );
    readfile( $file_path );
    exit;
}