<?php

if( ! defined( "WP_UNINSTALL_PLUGIN" ) ) {
    exit;
}

# Delete the /locker_up_pdfs directory and all its files during plugin uninstallation
$loc_up_private_dir = WP_CONTENT_DIR . "/locker_up_pdfs";
if( file_exists( $loc_up_private_dir ) && is_dir( $loc_up_private_dir ) ) {
    # Delete all pdf files inside the private folder
    foreach( glob( $loc_up_private_dir . "/*.pdf" ) as $file ) {
        @unlink( $file );
    }

    # Delete the folder
    @rmdir( $loc_up_private_dir );
}

# Delete options (settings)
delete_option( "loc_up_license_expiry" );
delete_option( "loc_up_license_status" );
delete_option( "loc_up_license_key" );

delete_option( "packing_label_size" );
delete_option( "packing_logo" );
delete_option( "vat_number" );
delete_option( "greeting" );
delete_option( "shipping_label_size" );    
delete_option( "packing_roll_width" );
delete_option( "shipping_roll_width" );
delete_option( "shipping_return_address" );